--[[
	Bongos PvP
		zone map bar
--]]


local Bongos = LibStub('AceAddon-3.0'):GetAddon('Bongos3')
local ZoneMap = Bongos:NewModule('ZoneMap', 'AceEvent-3.0')


--[[ Startup ]]--

function ZoneMap:Load()
	local defaults = {
		point = 'BOTTOMRIGHT',
		x = -13,
		y = 75,
	}

	self.bar, isNew = Bongos.Bar:Create('zone map', defaults, nil, 'MEDIUM')
	if isNew then
		self.LoadBar(self.bar)
	end
end

function ZoneMap:LoadBar()
	for k,v in pairs(ZoneMap) do self[k] = v end
	self.dropdown = self:CreateDropdown()
	
	local button = MiniMapWorldMapButton
	button:RegisterForClicks("LeftButtonUp","RightButtonUp")
	button:SetScript("OnClick", function() self:OnButtonClick() end)
	
	if IsAddOnLoaded('Blizzard_BattlefieldMinimap') then
		self:AttachMinimap()
	else
		self:RegisterEvent('ADDON_LOADED', function(_, addon)
			if addon == 'Blizzard_BattlefieldMinimap' then
				self:UnregisterEvent('ADDON_LOADED')
				self:AttachMinimap()
			end
		end)
		self:SetHeight(150) self:SetWidth(225)
	end
end

function ZoneMap:AttachMinimap()
	local frame = BattlefieldMinimap
	frame:ClearAllPoints()
	frame:SetPoint('Topleft', self, 2, -3)
	
	self:SetHeight(frame:GetHeight())
	self:SetWidth(frame:GetWidth())
	self:Attach(frame)
	
	BattlefieldMinimapTab:SetScript('OnShow', self.Hide)
	OpacityFrameSlider:SetValue(0)
	BattlefieldMinimap_SetOpacity()
	BattlefieldMinimap_SetOpacity = function() end
end

function ZoneMap:Unload()
	self.bar:Destroy()
end


--[[ Dropdown ]]--

function ZoneMap:CreateDropdown()
	local drop = CreateFrame("Frame", self.name .. "BattlefieldDrop", MiniMapWorldMapButton, "UIDropDownMenuTemplate")
	UIDropDownMenu_Initialize(drop, self.InitializeDropdown,"MENU")
	
	drop:SetClampedToScreen(true)
	return drop
end

function ZoneMap:OnButtonClick()
	if arg1=="LeftButton" then
		ToggleWorldMap()
	elseif arg1=="RightButton" then
		local cy, cx = GetCursorPosition()
		local y, x = 20, 8
		if ( cy > 800 ) then y = -170 end
		if ( cx < 250 ) then x = 95 end
		ToggleDropDownMenu(1, nil, self.dropdown, this:GetName(), y, x)
	end
end

function ZoneMap:InitializeDropdown()
	local info = UIDropDownMenu_CreateInfo()
	info.text = BATTLEFIELD_MINIMAP
	info.notClickable = 1
	info.isTitle = 1
	UIDropDownMenu_AddButton(info)
	
	WorldMapZoneMinimapDropDown_Initialize()
end


--[[ Menu ]]--

function ZoneMap:CreateMenu()
	local menu = Bongos.Menu:Create(self.id)
	local panel = menu:AddLayoutPanel()
	
	local showTeam = panel:CreateCheckButton(SHOW_BATTLEFIELDMINIMAP_PLAYERS)
	showTeam:SetScript('OnShow', function() this:SetChecked(BattlefieldMinimapOptions.showPlayers) end)
	showTeam:SetScript('OnClick', function() BattlefieldMinimap_TogglePlayers() this:Show() end)
	
	return menu
end